/*****************************************************************************\
|*
|*  COPYRIGHT:     Copyright (c) 2004, Altium
|*
|*  DESCRIPTION:   Patterns
|*
\*****************************************************************************/

#define HEX__(n) 0x##n##LU
/* 8-bit conversion function */
#define B8__(x) ((x&0x0000000FLU)?1:0)  \
               +((x&0x000000F0LU)?2:0)  \
               +((x&0x00000F00LU)?4:0)  \
               +((x&0x0000F000LU)?8:0)  \
               +((x&0x000F0000LU)?16:0) \
               +((x&0x00F00000LU)?32:0) \
               +((x&0x0F000000LU)?64:0) \
               +((x&0xF0000000LU)?128:0)
/* *** user macros *** */
/* for upto 8-bit binary constants */
#define B8(d) ((unsigned char)B8__(HEX__(d)))


unsigned char Patterns[64] = {

//0.   Live Design Logo
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000001),
       B8(00000011),
       B8(00000110),
       B8(00001100),
       B8(00001100),
//1.
       B8(00000000),
       B8(00000011),
       B8(00011110),
       B8(00010000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
//2.
       B8(00000001),
       B8(00011000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
//3.
       B8(00010000),
       B8(00001100),
       B8(00000110),
       B8(00000010),
       B8(00000011),
       B8(00000011),
       B8(00000011),
       B8(00000011),
//4.
       B8(00001100),
       B8(00011000),
       B8(00001000),
       B8(00001000),
       B8(00001100),
       B8(00000100),
       B8(00000010),
       B8(00000001),
//5.
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000011),
//6.
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000000),
       B8(00000001),
       B8(00001111),
//7.
       B8(00000011),
       B8(00000011),
       B8(00000111),
       B8(00000110),
       B8(00001100),
       B8(00011000),
       B8(00010000),
       B8(00000000)
};


